/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.creativetab;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.behaviours.interfaces.BehaviourLeaves;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlantLike;
import org.betterx.bclib.creativetab.BCLCreativeTabManager;
import org.jetbrains.annotations.NotNull;

public class BCLCreativeTab {
    public static CreativeTabPredicate NATURE = item -> {
        BlockItem bi;
        return item instanceof BlockItem && ((bi = (BlockItem)item).m_40614_() instanceof BehaviourPlantLike || bi.m_40614_() instanceof BehaviourLeaves);
    };
    public static CreativeTabPredicate BLOCKS = item -> item instanceof BlockItem;
    public final ResourceLocation id;
    public final ItemLike icon;
    public final Component title;
    public final CreativeTabPredicate predicate;
    public final ResourceKey<CreativeModeTab> key;
    protected final List<Item> items;

    public BCLCreativeTab(ResourceLocation id, ItemLike icon, Component title, CreativeTabPredicate predicate) {
        this.id = id;
        this.icon = icon;
        this.title = title;
        this.predicate = predicate;
        this.key = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)id);
        this.items = new LinkedList<Item>();
    }

    void addItem(Item item) {
        this.items.add(item);
    }

    public static interface CreativeTabPredicate {
        public boolean contains(Item var1);
    }

    public static class Builder {
        private final String name;
        private final ResourceLocation id;
        private ItemLike icon;
        private CreativeTabPredicate predicate = item -> true;
        private Component title;
        private final BCLCreativeTabManager manager;

        public Builder(@NotNull BCLCreativeTabManager manager, @NotNull String name) {
            this.name = name;
            this.manager = manager;
            this.id = new ResourceLocation(manager.modID, name + "_tab");
            this.title = Component.m_237115_((String)("itemGroup." + manager.modID + "." + name));
        }

        public Builder setIcon(ItemLike icon) {
            this.icon = icon;
            return this;
        }

        public Builder setPredicate(CreativeTabPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder setTitle(Component title) {
            this.title = title;
            return this;
        }

        public BCLCreativeTabManager build() {
            if (this.icon == null) {
                throw new IllegalStateException("Icon must be set");
            }
            BCLCreativeTab res = new BCLCreativeTab(this.id, this.icon, this.title, this.predicate);
            this.manager.tabs.add(res);
            return this.manager;
        }
    }
}

